﻿//////////////////////////////////////////////
// DepthStencilState.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Resources/Resource.h"

#include "../Utils/DxDefinesWrapper.h"

#include "../Samplers/Enums/ComparisonFunction.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT DepthStencilState : public Resource, public nkExport::Exportable
	{
		public :

			// Getters depth
			virtual bool getDepthEnabled () const = 0 ;
			virtual DEPTH_WRITE_MASK getDepthMasking () const = 0 ;
			virtual COMPARISON_FUNCTION getDepthComparison() const = 0 ;

			// Getters Stencil
			virtual bool getStencilEnabled () const = 0 ;
			virtual unsigned char getStencilReadMask () const = 0 ;
			virtual unsigned char getStencilWriteMask () const = 0 ;
			virtual STENCIL_OP getStencilFailFrontFace () const = 0 ;
			virtual STENCIL_OP getStencilOkDepthFailFrontFace () const = 0 ;
			virtual STENCIL_OP getStencilDepthOkFrontFace () const = 0 ;
			virtual COMPARISON_FUNCTION getStencilComparisonFrontFace () const = 0 ;
			virtual STENCIL_OP getStencilFailBackFace () const = 0 ;
			virtual STENCIL_OP getStencilOkDepthFailBackFace () const = 0 ;
			virtual STENCIL_OP getStencilDepthOkBackFace () const = 0 ;
			virtual COMPARISON_FUNCTION getStencilComparisonBackFace () const = 0 ;

			// Setters global
			virtual void resetToDefault () = 0 ;

			// Setters Depth
			virtual void setDepthEnabled (bool value) = 0 ;
			virtual void setDepthMasking (DEPTH_WRITE_MASK value) = 0 ;
			virtual void setDepthComparison (COMPARISON_FUNCTION value) = 0 ;

			// Setters Stencil
			virtual void setStencilEnabled (bool value) = 0 ;
			virtual void setStencilReadMask (unsigned char value) = 0 ;
			virtual void setStencilWriteMask (unsigned char value) = 0 ;
			virtual void setStencilFailFrontFace (STENCIL_OP value) = 0 ;
			virtual void setStencilOkDepthFailFrontFace (STENCIL_OP value) = 0 ;
			virtual void setStencilDepthOkFrontFace (STENCIL_OP value) = 0 ;
			virtual void setStencilComparisonFrontFace (COMPARISON_FUNCTION value) = 0 ;
			virtual void setStencilFailBackFace (STENCIL_OP value) = 0 ;
			virtual void setStencilOkDepthFailBackFace (STENCIL_OP value) = 0 ;
			virtual void setStencilDepthOkBackFace (STENCIL_OP value) = 0 ;
			virtual void setStencilComparisonBackFace (COMPARISON_FUNCTION value) = 0 ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) ;
			virtual void importClassFromTree (nkExport::Node* rootNode) ;

		public :

			// Statics
			static nkMemory::UniquePtr<DepthStencilState> create (System* system = nullptr) ;

		protected :

			// Constructor
			DepthStencilState (System* system) noexcept ;
	} ;
}